/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.block.CTBlockIngredient;
import com.blamejared.crafttweaker.api.plugin.CraftTweakerPlugin;
import com.blamejared.crafttweaker.api.plugin.ICraftTweakerPlugin;
import com.blamejared.crafttweaker.api.plugin.IRecipeHandlerRegistrationHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.impl.registry.CraftTweakerRegistry;
import com.blamejared.crafttweaker.natives.block.ExpandBlock;
import com.blamejared.crafttweaker.natives.block.ExpandBlockState;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.StateIngredientBlock;
import vazkii.botania.common.crafting.StateIngredientBlockState;
import vazkii.botania.common.crafting.StateIngredientBlocks;
import vazkii.botania.common.crafting.StateIngredientCompound;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.crafting.StateIngredientTag;
import vazkii.botania.common.crafting.recipe.ArmorUpgradeRecipe;
import vazkii.botania.common.crafting.recipe.ManaUpgradeRecipe;
import vazkii.botania.common.crafting.recipe.ShapelessManaUpgradeRecipe;
import vazkii.botania.common.crafting.recipe.TwigWandRecipe;
import vazkii.botania.common.crafting.recipe.WaterBottleMatchingRecipe;
import vazkii.botania.common.integration.crafttweaker.recipe.handler.DelegatingCraftingRecipeHandler;

@CraftTweakerPlugin(value="botania:default")
public class CTPlugin
implements ICraftTweakerPlugin {
    public void registerRecipeHandlers(IRecipeHandlerRegistrationHandler handler) {
        handler.registerRecipeHandler(ArmorUpgradeRecipe.class, new DelegatingCraftingRecipeHandler(RecipeType.f_44107_, (Supplier<IRecipeHandler<ShapedRecipe>>)Suppliers.memoize(() -> CraftTweakerRegistry.get().getRecipeHandlerFor(ShapedRecipe.class)), ArmorUpgradeRecipe::new));
        handler.registerRecipeHandler(ManaUpgradeRecipe.class, new DelegatingCraftingRecipeHandler(RecipeType.f_44107_, (Supplier<IRecipeHandler<ShapedRecipe>>)Suppliers.memoize(() -> CraftTweakerRegistry.get().getRecipeHandlerFor(ShapedRecipe.class)), ManaUpgradeRecipe::new));
        handler.registerRecipeHandler(ShapelessManaUpgradeRecipe.class, new DelegatingCraftingRecipeHandler(RecipeType.f_44107_, (Supplier<IRecipeHandler<ShapelessRecipe>>)Suppliers.memoize(() -> CraftTweakerRegistry.get().getRecipeHandlerFor(ShapelessRecipe.class)), ShapelessManaUpgradeRecipe::new));
        handler.registerRecipeHandler(TwigWandRecipe.class, new DelegatingCraftingRecipeHandler(RecipeType.f_44107_, (Supplier<IRecipeHandler<ShapedRecipe>>)Suppliers.memoize(() -> CraftTweakerRegistry.get().getRecipeHandlerFor(ShapedRecipe.class)), TwigWandRecipe::new));
        handler.registerRecipeHandler(WaterBottleMatchingRecipe.class, new DelegatingCraftingRecipeHandler(RecipeType.f_44107_, (Supplier<IRecipeHandler<ShapedRecipe>>)Suppliers.memoize(() -> CraftTweakerRegistry.get().getRecipeHandlerFor(ShapedRecipe.class)), WaterBottleMatchingRecipe::new));
    }

    public static StateIngredient blockIngredientToStateIngredient(CTBlockIngredient ingredient) {
        if (ingredient == null) {
            return null;
        }
        return (StateIngredient)ingredient.mapTo(StateIngredientHelper::of, StateIngredientHelper::of, (blockTagKey, integer) -> StateIngredientHelper.of((TagKey<Block>)blockTagKey), stream -> StateIngredientHelper.compound(stream.toList()));
    }

    public static String ingredientToCommandString(StateIngredient ingr) {
        if (ingr instanceof StateIngredientTag) {
            StateIngredientTag sit = (StateIngredientTag)ingr;
            return CraftTweakerTagRegistry.INSTANCE.knownTagManager(Registry.f_122901_).tag(sit.getTagId()).getCommandString();
        }
        if (ingr instanceof StateIngredientBlock) {
            StateIngredientBlock sib = (StateIngredientBlock)ingr;
            return ExpandBlock.getCommandString((Block)sib.getBlock());
        }
        if (ingr instanceof StateIngredientBlockState) {
            StateIngredientBlockState sibs = (StateIngredientBlockState)ingr;
            return ExpandBlockState.getCommandString((BlockState)sibs.getState());
        }
        if (ingr instanceof StateIngredientBlocks) {
            return ingr.getDisplayed().stream().map(BlockBehaviour.BlockStateBase::m_60734_).map(ExpandBlock::getCommandString).collect(Collectors.joining(", ", "[", "]"));
        }
        if (ingr instanceof StateIngredientCompound) {
            StateIngredientCompound sic = (StateIngredientCompound)ingr;
            return sic.getIngredients().stream().map(CTPlugin::ingredientToCommandString).collect(Collectors.joining(" | "));
        }
        return ingr.toString();
    }
}

